model:setName( "ContrastOnly II" )
--model:caption( "HighKey II (var.1)" )

model:addSource("inputImage")
model:addSource("originalImage")
model:addSource("histogram0")
model:addSource("histogram1")
model:addSource("histogram2")
model:addSource("histogram3")
model:addSource("histogram4")
model:addSource("histogram5")

--basis filter added
f0= model:addFilter("LscAndSinterFilter")		-- soft contrast
f3= model:addFilter("LevelsAndCurvesFilter")	-- flat for rgb
f4= model:addFilter("LevelsAndCurvesFilter")	-- flat for ctr only
f1= model:addFilter("LevelsAndCurvesFilter")	-- standard
f2= model:addFilter("LevelsAndCurvesFilter")	-- ctr only

curve_neutral = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="1"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="0"/>
<key name="intNodeX0" value="0"/><key name="intNodeY0" value="0"/><key name="intNodeX1" value="0"/><key name="intNodeY1" value="0"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_flat_weak = [[<Lac_serialization>
<key name="lowNodeX" value="0.0"/>
<key name="lowNodeY" value="0.05"/>
<key name="highNodeX" value="1.0"/>
<key name="highNodeY" value="0.95"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="1"/>
<key name="intNodeX0" value="0.5"/><key name="intNodeY0" value="0.5"/><key name="intNodeX1" value="0"/><key name="intNodeY1" value="0"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_flat_stronger = [[<Lac_serialization>
<key name="lowNodeX" value="0.0"/>
<key name="lowNodeY" value="0.3"/>
<key name="highNodeX" value="1.0"/>
<key name="highNodeY" value="0.7"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="1"/>
<key name="intNodeX0" value="0.5"/><key name="intNodeY0" value="0.5"/><key name="intNodeX1" value="0"/><key name="intNodeY1" value="0"/><key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

curve_s_fine = [[<Lac_serialization>
<key name="lowNodeX" value="0"/>
<key name="lowNodeY" value="0"/>
<key name="highNodeX" value="1"/>
<key name="highNodeY" value="1"/>
<key name="gamma" value="0"/>
<key name="intNodeCount" value="2"/>
<key name="intNodeX0" value="0.716667"/>
<key name="intNodeY0" value="0.872222"/>
<key name="intNodeX1" value="0.322222"/>
<key name="intNodeY1" value="0.166667"/>
<key name="intNodeX2" value="0"/><key name="intNodeY2" value="0"/><key name="intNodeX3" value="0"/><key name="intNodeY3" value="0"/><key name="intNodeX4" value="0"/><key name="intNodeY4" value="0"/><key name="intNodeX5" value="0"/><key name="intNodeY5" value="0"/><key name="intNodeX6" value="0"/><key name="intNodeY6" value="0"/><key name="intNodeX7" value="0"/><key name="intNodeY7" value="0"/><key name="intNodeX8" value="0"/><key name="intNodeY8" value="0"/><key name="intNodeX9" value="0"/><key name="intNodeY9" value="0"/>
</Lac_serialization>]]

-- LSC for Soft Contrast and Saturation

lsc = model:getFilter(f0)
lsc:setFloatParameter( "baseFill", 1 )
lsc:setIntParameter( "sinterStrucLscMode0_", 3  )
lsc:setIntParameter( "sinterStrucLscMode1_" ,0 )
lsc:setIntParameter( "tileSizeLevel0", 1 )
lsc:setIntParameter( "tileSizeLevel1",0 )
lsc:setIntParameter( "selectedChannel0_", 0 )
lsc:setIntParameter( "selectedChannel1_", 0 )
lsc:setFloatParameter( "sigma20", 60 )
lsc:setFloatParameter( "sigma21", 40 )
lsc:setIntParameter("lemmingType0", 0)
lsc:setIntParameter( "lemmingType1",0 )
lsc:setFloatParameter("maxDeriv0", 7)
lsc:setFloatParameter( "maxDeriv1", 2 )
lsc:setFloatParameter( "strength0", 93 )
lsc:setFloatParameter( "strength1", 0 )
lsc:setFloatParameter( "strengthFactor", 0 )
lsc:setFloatParameter( "totalStrength", 100 )
lsc:setFloatParameter( "brightness", 0)
lsc:setFloatParameter( "contrast", 0 )
lsc:setFloatParameter( "saturation", 0)
lsc:setFloatParameter( "csStrength", 0 )
lsc:setFloatParameter( "deltaT", 34 )
lsc:setFloatParameter( "numberOfTimesteps", 2)
lsc:setFloatParameter( "modifier_A", 0.75)
lsc:setFloatParameter( "modifier_B", 48)
lsc:setFloatParameter( "modifier_C",3)
lsc:setFloatParameter( "modifier_D", 75)

model:forwardParameter( "brightness", f0, "brightness",  "Brightness", "")

model:addFloatSlider("protect_shadows", 0,0,1,"protect_shadows_function", "Shadows", "")
function protect_shadows_function(v)
  lsc = model:getFilter(f0)
  lsc:setFloatParameter( "protectShadows", v*100)
  lsc:setFloatParameter( "boostShadows", (v*100)/7)
  update_protect_function()
end

model:addFloatSlider("protect_hilights", 0,0,1,"protect_hilights_function", "Highlights", "")
function protect_hilights_function(v)
  lsc = model:getFilter(f0)
  lsc:setFloatParameter( "protectHighlights", v*100)
  lsc:setFloatParameter( "boostHighlights", (v*100)/7)
  update_protect_function()
end


-- Flat Curve 3

lac3 = model:getFilter(f3)
lac3:setFloatParameter( "strength", 0 )

lac3:setLacData( "lacdataRGB", curve_flat_stronger )
lac3:setLacData( "lacdataR", curve_neutral )
lac3:setLacData( "lacdataG", curve_neutral )
lac3:setLacData( "lacdataB", curve_neutral )
lac3:setLacData( "lacdataSmartBrightness", curve_flat_weak )

-- Flat Curve 4

lac4 = model:getFilter(f4)
lac4:setFloatParameter( "strength", 0 )

lac4:setLacData( "lacdataRGB", curve_flat_weak )
lac4:setLacData( "lacdataR", curve_neutral )
lac4:setLacData( "lacdataG", curve_neutral )
lac4:setLacData( "lacdataB", curve_neutral )
lac4:setLacData( "lacdataSmartBrightness", curve_flat_stronger )




-- Standard-S-Curve

lac = model:getFilter(f1)
lac:setFloatParameter( "strength", 0 )
--model:forwardFloatParameter( "strength", f1, "strength", 0, 0, 100, "Standard Contrast", "")

-- new debug:
function standard_contrast_function(v)
	value 		= v * 100
	value_neg 	= v * -100
	if (value<0) then value = 0 end
	if (value_neg<0) then value_neg = 0 end
	lac = model:getFilter(f1)
	lac3 = model:getFilter(f3)
	lac:setFloatParameter( "strength", value )
	lac3:setFloatParameter( "strength", value_neg )
end
model:addFloatSlider("standard_contrast", 0,-1,1,"standard_contrast_function", "Contrast", "")


lac:setLacData( "lacdataRGB", curve_s_fine )
lac:setLacData( "lacdataR", curve_neutral )
lac:setLacData( "lacdataG", curve_neutral )
lac:setLacData( "lacdataB", curve_neutral )
lac:setLacData( "lacdataSmartBrightness", curve_neutral )


-- ContrastOnly-S-Curve

lac2 = model:getFilter(f2)
lac2:setFloatParameter( "strength", 0 )
--model:forwardFloatParameter( "strength2", f2, "strength", 0, 0, 100, "Contrast Only", "adds a type of contrast that does not modify the colors or saturation")
function contrast_only_function(v)
	value 		= v * 100
	value_neg 	= v * -100
	if (value<0) then value = 0 end
	if (value_neg<0) then value_neg = 0 end
	lac2 = model:getFilter(f2)
	lac4 = model:getFilter(f4)
	lac2:setFloatParameter( "strength", value )
	lac4:setFloatParameter( "strength", value_neg )
end
model:addFloatSlider("strength", 0.5,-1,1,"contrast_only_function", "Contrast Only", "")

lac2:setLacData( "lacdataRGB", curve_neutral )
lac2:setLacData( "lacdataR", curve_neutral )
lac2:setLacData( "lacdataG", curve_neutral )
lac2:setLacData( "lacdataB", curve_neutral )
lac2:setLacData( "lacdataSmartBrightness", curve_s_fine )


-- More Parameter from LSC
function soft_contrast_function(v)
 lsc = model:getFilter(f0)
 lsc:setFloatParameter( "strengthFactor", v*100)
end
model:addFloatSliderUiRangeAdapted( "strengthFactor", 0, 0, 1, -100, 100, "soft_contrast_function", "Soft Contrast", "")

--model:forwardFloatParameter( "strengthFactor", f0, "strengthFactor", 0, -100, 100, "Soft Contrast", "")
model:forwardParameter( "saturation", f0, "saturation",  "Saturation", "")




 --Filtername: 'LevelsAndCurvesFilter'
 --ParameterName: 'strength', min: '0', max: '100', default: '100', type: 'float'
 --ParameterName: 'lacdataRGB', min: '-1', max: '-1', default: '-1', type: 'unknown', comment: Filter parameter was neither float nor int!
 --ParameterName: 'lacdataR', min: '-1', max: '-1', default: '-1', type: 'unknown', comment: Filter parameter was neither float nor int!
 --ParameterName: 'lacdataG', min: '-1', max: '-1', default: '-1', type: 'unknown', comment: Filter parameter was neither float nor int!
 --ParameterName: 'lacdataB', min: '-1', max: '-1', default: '-1', type: 'unknown', comment: Filter parameter was neither float nor int!
 --ParameterName: 'lacdataSmartBrightness', min: '-1', max: '-1', default: '-1', type: 'unknown', comment: Filter parameter was neither float nor int!
 --ParameterName: 'lacComboBox', min: '0', max: '5', default: '0', type: 'int', comment: Comboboxes containing group labels don't have sequential indexing! Each group means an index gap.

